/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import se.mickelus.mutil.gui.GuiButton;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiItem;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiStringSmall;
import se.mickelus.mutil.gui.GuiTextSmall;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.blocks.workbench.gui.CraftButtonGui;
import se.mickelus.tetra.blocks.workbench.gui.GuiExperience;
import se.mickelus.tetra.blocks.workbench.gui.GuiSources;
import se.mickelus.tetra.blocks.workbench.gui.ToolRequirementListGui;
import se.mickelus.tetra.gui.GuiItemRolling;
import se.mickelus.tetra.gui.GuiMagicUsage;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialApplicable;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialTranslation;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class GuiSchematicDetail
extends GuiElement {
    private static final int MAX_NUM_SLOTS = 2;
    private final GuiElement glyph;
    private final GuiString title;
    private final GuiSources sources;
    private final GuiTextSmall description;
    private final CraftButtonGui craftButton;
    private final GuiString[] slotNames;
    private final GuiString[] slotQuantities;
    private final GuiItemRolling[] slotPlaceholders;
    private final GuiTexture[] slotBorders;
    private final GuiMagicUsage magicCapacity;
    private final ToolRequirementListGui toolRequirementList;
    private final GuiExperience experienceIndicator;
    private final HoloMaterialTranslation materialTranslation;
    private final HoloMaterialApplicable applicableMaterials;
    private UpgradeSchematic schematic;
    private List<Component> descriptionTooltip;

    public GuiSchematicDetail(int x, int y, Runnable backListener, Runnable craftListener) {
        super(x, y, 224, 67);
        this.addChild((GuiElement)new GuiButton(-4, this.height - 2, 40, 8, "< " + I18n.m_118938_((String)"tetra.workbench.schematic_detail.back", (Object[])new Object[0]), backListener));
        this.glyph = new GuiElement(3, 3, 16, 16);
        this.addChild(this.glyph);
        this.title = new GuiString(19, 6, 100, "");
        this.addChild((GuiElement)this.title);
        this.sources = new GuiSources(19, 15, 100);
        this.addChild(this.sources);
        this.description = new GuiTextSmall(5, 20, 105, "");
        this.addChild((GuiElement)this.description);
        this.materialTranslation = new HoloMaterialTranslation(110, 4);
        this.addChild(this.materialTranslation);
        this.applicableMaterials = new HoloMaterialApplicable(111, 13);
        this.addChild(this.applicableMaterials);
        this.slotNames = new GuiString[2];
        this.slotQuantities = new GuiString[2];
        this.slotPlaceholders = new GuiItemRolling[2];
        this.slotBorders = new GuiTexture[2];
        for (int i = 0; i < 2; ++i) {
            this.slotNames[i] = new GuiString(140, 9 + i * 17, "");
            this.slotNames[i].setVisible(false);
            this.addChild((GuiElement)this.slotNames[i]);
            this.slotQuantities[i] = new GuiStringSmall(139, 18 + i * 18, "");
            this.slotQuantities[i].setVisible(false);
            this.addChild((GuiElement)this.slotQuantities[i]);
            this.slotPlaceholders[i] = new GuiItemRolling(121, 5 + i * 18);
            this.slotPlaceholders[i].setVisible(false);
            this.slotPlaceholders[i].setCountVisibility(GuiItem.CountMode.never);
            this.addChild(this.slotPlaceholders[i]);
            this.slotBorders[i] = new GuiTexture(121, 5 + i * 18, 16, 16, 52, 16, GuiTextures.workbench);
            this.slotBorders[i].setOpacity(0.8f);
            this.slotBorders[i].setVisible(false);
            this.addChild((GuiElement)this.slotBorders[i]);
        }
        this.magicCapacity = new GuiMagicUsage(121, 28, 80);
        this.addChild(this.magicCapacity);
        this.toolRequirementList = new ToolRequirementListGui(80, 39);
        this.addChild(this.toolRequirementList);
        this.experienceIndicator = new GuiExperience(192, 42, "tetra.workbench.schematic_detail.experience");
        this.addChild(this.experienceIndicator);
        this.craftButton = new CraftButtonGui(140, 40, craftListener);
        this.addChild((GuiElement)this.craftButton);
    }

    public void update(Level level, BlockPos pos, WorkbenchTile blockEntity, UpgradeSchematic schematic, ItemStack itemStack, String slot, ItemStack[] materials, Map<ToolAction, Integer> availableTools, Player player) {
        int i;
        GuiTexture glyphTexture;
        this.schematic = schematic;
        this.title.setString(schematic.getName());
        this.title.setColor(schematic.getRarity().tint);
        this.sources.update(schematic);
        String descriptionString = schematic.getDescription(itemStack);
        this.description.setString(ChatFormatting.GRAY + descriptionString.replace(ChatFormatting.RESET.toString(), ChatFormatting.RESET.toString() + ChatFormatting.GRAY));
        this.descriptionTooltip = ImmutableList.of((Object)Component.m_237113_((String)descriptionString));
        this.materialTranslation.setVisible(schematic.getNumMaterialSlots() > 0);
        this.applicableMaterials.setVisible(schematic.getNumMaterialSlots() > 0);
        if (schematic.getNumMaterialSlots() > 0) {
            this.materialTranslation.update(schematic);
            this.applicableMaterials.update(level, pos, blockEntity, itemStack, slot, schematic, player);
        }
        this.glyph.clearChildren();
        GlyphData glyphData = schematic.getGlyph();
        GuiTexture border = null;
        if (schematic.getType() == SchematicType.major) {
            border = new GuiTexture(0, 2, 16, 9, 52, 3, GuiTextures.workbench);
            glyphTexture = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else if (schematic.getType() == SchematicType.minor) {
            border = new GuiTexture(2, 1, 11, 11, 68, 0, GuiTextures.workbench);
            glyphTexture = new GuiTexture(4, 3, 8, 8, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else if (schematic.getType() == SchematicType.improvement) {
            border = new GuiTexture(0, 2, 16, 9, 52, 3, GuiTextures.workbench);
            glyphTexture = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        } else {
            glyphTexture = new GuiTexture(-1, -1, 16, 16, glyphData.textureX, glyphData.textureY, glyphData.textureLocation);
        }
        if (border != null) {
            border.setOpacity(0.3f);
            border.setColor(schematic.getRarity().tint);
            this.glyph.addChild((GuiElement)border);
        }
        glyphTexture.setColor(schematic.getRarity().tint);
        this.glyph.addChild((GuiElement)glyphTexture);
        if (schematic.getType() == SchematicType.improvement) {
            this.glyph.addChild((GuiElement)new GuiTexture(7, 7, 7, 7, 68, 16, GuiTextures.workbench).setColor(0x7F7F7F));
        }
        for (i = 0; i < schematic.getNumMaterialSlots(); ++i) {
            this.slotNames[i].setString(schematic.getSlotName(itemStack, i));
            this.slotNames[i].setVisible(true);
            this.slotPlaceholders[i].setVisible(i < materials.length && materials[i].m_41619_());
            this.slotPlaceholders[i].setItems(schematic.getSlotPlaceholders(itemStack, i));
            this.slotBorders[i].setVisible(true);
            if (schematic.acceptsMaterial(itemStack, slot, i, materials[i])) {
                int requiredCount = schematic.getRequiredQuantity(itemStack, i, materials[i]);
                if (!materials[i].m_41619_() && requiredCount > 1) {
                    this.slotQuantities[i].setString("/" + requiredCount);
                    this.slotQuantities[i].setColor(materials[i].m_41613_() < requiredCount ? 0xFF5555 : 0xFFFFFF);
                }
                this.slotQuantities[i].setVisible(!materials[i].m_41619_() && requiredCount > 1);
                continue;
            }
            this.slotQuantities[i].setVisible(false);
        }
        for (i = schematic.getNumMaterialSlots(); i < 2; ++i) {
            this.slotNames[i].setVisible(false);
            this.slotQuantities[i].setVisible(false);
            this.slotPlaceholders[i].setVisible(false);
            this.slotBorders[i].setVisible(false);
        }
        this.toolRequirementList.update(schematic, itemStack, slot, materials, availableTools);
        int xpCost = schematic.getExperienceCost(itemStack, materials, slot);
        this.experienceIndicator.setVisible(xpCost > 0);
        if (xpCost > 0) {
            if (!player.m_7500_()) {
                this.experienceIndicator.update(xpCost, xpCost <= player.f_36078_);
            } else {
                this.experienceIndicator.update(xpCost, true);
            }
        }
    }

    public void updateMagicCapacity(UpgradeSchematic schematic, String slot, ItemStack itemStack, ItemStack previewStack) {
        if (slot != null && (schematic != null && SchematicType.major.equals((Object)schematic.getType()) && this.magicCapacity.providesCapacity(itemStack, previewStack, slot) || this.magicCapacity.hasChanged(itemStack, previewStack, slot))) {
            this.magicCapacity.update(itemStack, previewStack, slot);
            this.magicCapacity.setVisible(true);
        } else {
            this.magicCapacity.setVisible(false);
        }
    }

    public void updateAvailableTools(Map<ToolAction, Integer> availableTools) {
        this.toolRequirementList.updateAvailableTools(availableTools);
    }

    public void updateButton(UpgradeSchematic schematic, Player player, ItemStack itemStack, ItemStack previewStack, ItemStack[] materials, String slot, Map<ToolAction, Integer> availableTools) {
        this.craftButton.update(schematic, player, itemStack, previewStack, materials, slot, availableTools);
    }

    public List<Component> getTooltipLines() {
        if (this.description.hasFocus()) {
            return this.descriptionTooltip;
        }
        return super.getTooltipLines();
    }
}

